# ASN.1 module Ieee1609Dot2BaseTypes
 OID: _{iso(1) identified-organization(3) ieee(111) standards-association-numbered-series-standards(2) wave-stds(1609) dot2(2) base(1) base-types(2) major-version-2(2) minor-version-4(4)}_
 @note Section references in this file are to clauses in IEEE Std
 1609.2 unless indicated otherwise. Full forms of acronyms and
 abbreviations used in this file are specified in 3.2.


## Data Elements:
### <a name="Uint3"></a>Uint3

 This atomic type is used in the definition of other data structures.
 It is for non-negative integers up to 7, i.e., (hex)07.



```asn1
Uint3 ::= INTEGER (0..7)
```

### <a name="Uint8"></a>Uint8

 This atomic type is used in the definition of other data structures.
 It is for non-negative integers up to 255, i.e., (hex)ff.



```asn1
Uint8 ::= INTEGER (0..255)
```

### <a name="Uint16"></a>Uint16

 This atomic type is used in the definition of other data structures.
 It is for non-negative integers up to 65,535, i.e., (hex)ff ff.



```asn1
Uint16 ::= INTEGER (0..65535)
```

### <a name="Uint32"></a>Uint32

 This atomic type is used in the definition of other data structures.
 It is for non-negative integers up to 4,294,967,295, i.e.,
 (hex)ff ff ff ff.



```asn1
Uint32 ::= INTEGER (0..4294967295)
```

### <a name="Uint64"></a>Uint64

 This atomic type is used in the definition of other data structures.
 It is for non-negative integers up to 18,446,744,073,709,551,615, i.e.,
 (hex)ff ff ff ff ff ff ff ff.



```asn1
Uint64 ::= INTEGER (0..18446744073709551615)
```

### <a name="SequenceOfUint8"></a>SequenceOfUint8

 This type is used for clarity of definitions.



```asn1
SequenceOfUint8 ::= SEQUENCE OF Uint8
```

### <a name="SequenceOfUint16"></a>SequenceOfUint16

 This type is used for clarity of definitions.



```asn1
SequenceOfUint16 ::= SEQUENCE OF Uint16
```

### <a name="Opaque"></a>Opaque

 This is a synonym for ASN.1 OCTET STRING, and is used in the
 definition of other data structures.



```asn1
Opaque ::= OCTET STRING
```

### <a name="HashedId3"></a>HashedId3

 This type contains the truncated hash of another data structure.
 The HashedId3 for a given data structure is calculated by calculating the
 hash of the encoded data structure and taking the low-order three bytes of
 the hash output. The low-order three bytes are the last three bytes of the
 32-byte hash when represented in network byte order. If the data structure
 is subject to canonicalization it is canonicalized before hashing. See
 Example below.

 The hash algorithm to be used to calculate a HashedId3 within a
 structure depends on the context. In this standard, for each structure
 that includes a HashedId3 field, the corresponding text indicates how the
 hash algorithm is determined. See also the discussion in 5.3.9.

 Example: Consider the SHA-256 hash of the empty string:

 SHA-256("") =
 e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855

 The HashedId3 derived from this hash corresponds to the following:

 HashedId3 = 52b855.



```asn1
HashedId3 ::= OCTET STRING (SIZE(3))
```

### <a name="SequenceOfHashedId3"></a>SequenceOfHashedId3

 This type is used for clarity of definitions.



```asn1
SequenceOfHashedId3 ::= SEQUENCE OF HashedId3
```

### <a name="HashedId8"></a>HashedId8

 This type contains the truncated hash of another data structure.
 The HashedId8 for a given data structure is calculated by calculating the
 hash of the encoded data structure and taking the low-order eight bytes of
 the hash output. The low-order eight bytes are the last eight bytes of the
 hash when represented in network byte order. If the data structure
 is subject to canonicalization it is canonicalized before hashing. See
 Example below.

 The hash algorithm to be used to calculate a HashedId8 within a
 structure depends on the context. In this standard, for each structure
 that includes a HashedId8 field, the corresponding text indicates how the
 hash algorithm is determined. See also the discussion in 5.3.9.

 Example: Consider the SHA-256 hash of the empty string:

 SHA-256("") =
 e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855

 The HashedId8 derived from this hash corresponds to the following:

 HashedId8 = a495991b7852b855.



```asn1
HashedId8 ::= OCTET STRING (SIZE(8))
```

### <a name="HashedId10"></a>HashedId10

 This type contains the truncated hash of another data structure.
 The HashedId10 for a given data structure is calculated by calculating the
 hash of the encoded data structure and taking the low-order ten bytes of
 the hash output. The low-order ten bytes are the last ten bytes of the
 hash when represented in network byte order. If the data structure
 is subject to canonicalization it is canonicalized before hashing. See
 Example below.

 The hash algorithm to be used to calculate a HashedId10 within a
 structure depends on the context. In this standard, for each structure
 that includes a HashedId10 field, the corresponding text indicates how the
 hash algorithm is determined. See also the discussion in 5.3.9.

 Example: Consider the SHA-256 hash of the empty string:

 SHA-256("") =
 e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855

 The HashedId10 derived from this hash corresponds to the following:

 HashedId10 = 934ca495991b7852b855.



```asn1
HashedId10 ::= OCTET STRING (SIZE(10))
```

### <a name="HashedId32"></a>HashedId32

 This data structure contains the truncated hash of another data
 structure. The HashedId32 for a given data structure is calculated by
 calculating the hash of the encoded data structure and taking the
 low-order 32 bytes of the hash output. The low-order 32 bytes are the last
 32 bytes of the hash when represented in network byte order. If the data
 structure is subject to canonicalization it is canonicalized before
 hashing. See Example below.

 The hash algorithm to be used to calculate a HashedId32 within a
 structure depends on the context. In this standard, for each structure
 that includes a HashedId32 field, the corresponding text indicates how the
 hash algorithm is determined. See also the discussion in 5.3.9.

 Example: Consider the SHA-256 hash of the empty string:

 SHA-256("") =
 e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855

 The HashedId32 derived from this hash corresponds to the following:

 HashedId32 = e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b8
 55.



```asn1
HashedId32 ::= OCTET STRING (SIZE(32))
```

### <a name="HashedId48"></a>HashedId48

 This data structure contains the truncated hash of another data
 structure. The HashedId48 for a given data structure is calculated by
 calculating the hash of the encoded data structure and taking the
 low-order 48 bytes of the hash output. The low-order 48 bytes are the last
 48 bytes of the hash when represented in network byte order. If the data
 structure is subject to canonicalization it is canonicalized before
 hashing. See Example below.

 The hash algorithm to be used to calculate a HashedId48 within a
 structure depends on the context. In this standard, for each structure
 that includes a HashedId48 field, the corresponding text indicates how the
 hash algorithm is determined. See also the discussion in 5.3.9.

 Example: Consider the SHA-384 hash of the empty string:

 SHA-384("") = 38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6
 e1da274edebfe76f65fbd51ad2f14898b95b

 The HashedId48 derived from this hash corresponds to the following:

 HashedId48 = 38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e
 1da274edebfe76f65fbd51ad2f14898b95b.



```asn1
HashedId48 ::= OCTET STRING(SIZE(48))
```

### <a name="Time32"></a>Time32

 This type gives the number of (TAI) seconds since 00:00:00 UTC, 1
 January, 2004.



```asn1
Time32 ::= Uint32
```

### <a name="Time64"></a>Time64

 This data structure is a 64-bit integer giving an estimate of the
 number of (TAI) microseconds since 00:00:00 UTC, 1 January, 2004.



```asn1
Time64 ::= Uint64
```

### <a name="ValidityPeriod"></a>ValidityPeriod

 This type gives the validity period of a certificate. The start of
 the validity period is given by start and the end is given by
 start + duration.

Fields:
* start [**Time32**](#Time32) <br>
* duration [**Duration**](#Duration) <br>
```asn1
ValidityPeriod ::= SEQUENCE {
  start    Time32,
  duration Duration
}
```

### <a name="Duration"></a>Duration

 This structure represents the duration of validity of a
 certificate. The Uint16 value is the duration, given in the units denoted
 by the indicated choice. A year is considered to be 31556952 seconds,
 which is the average number of seconds in a year.

 @note Years can be mapped more closely to wall-clock days using the hours
 choice for up to 7 years and the sixtyHours choice for up to 448 years.

Fields:
* microseconds [**Uint16**](Ieee1609Dot2BaseTypes.md#Uint16) <br>
* milliseconds [**Uint16**](Ieee1609Dot2BaseTypes.md#Uint16) <br>
* seconds [**Uint16**](Ieee1609Dot2BaseTypes.md#Uint16) <br>
* minutes [**Uint16**](Ieee1609Dot2BaseTypes.md#Uint16) <br>
* hours [**Uint16**](Ieee1609Dot2BaseTypes.md#Uint16) <br>
* sixtyHours [**Uint16**](Ieee1609Dot2BaseTypes.md#Uint16) <br>
* years [**Uint16**](Ieee1609Dot2BaseTypes.md#Uint16) <br>
```asn1
Duration ::= CHOICE {
  microseconds Uint16,
  milliseconds Uint16,
  seconds      Uint16,
  minutes      Uint16,
  hours        Uint16,
  sixtyHours   Uint16,
  years        Uint16
}
```

### <a name="GeographicRegion"></a>GeographicRegion

 This structure represents a geographic region of a specified form.
 A certificate is not valid if any part of the region indicated in its
 scope field lies outside the region indicated in the scope of its issuer.

 @note Critical information fields:
   - If present, this is a critical information field as defined in 5.2.6.
 An implementation that does not recognize the indicated CHOICE when
 verifying a signed SPDU shall indicate that the signed SPDU is invalid in
 the sense of 4.2.2.3.2, that is, it is invalid in the sense that its
 validity cannot be established.
   - If selected, rectangularRegion is a critical information field as
 defined in 5.2.6. An implementation that does not support the number of
 RectangularRegion in rectangularRegions when verifying a signed SPDU shall
 indicate that the signed SPDU is invalid in the sense of 4.2.2.3.2, that
 is, it is invalid in the sense that its validity cannot be established.
 A conformant implementation shall support rectangularRegions fields
 containing at least eight entries.
   - If selected, identifiedRegion is a critical information field as
 defined in 5.2.6. An implementation that does not support the number of
 IdentifiedRegion in identifiedRegion shall reject the signed SPDU as
 invalid in the sense of 4.2.2.3.2, that is, it is invalid in the sense
 that its validity cannot be established. A conformant implementation shall
 support identifiedRegion fields containing at least eight entries.

Fields:
* circularRegion [**CircularRegion**](#CircularRegion) <br>
contains a single instance of the CircularRegion
 structure.

* rectangularRegion [**SequenceOfRectangularRegion**](#SequenceOfRectangularRegion) <br>
is an array of RectangularRegion structures
 containing at least one entry. This field is interpreted as a series of
 rectangles, which may overlap or be disjoint. The permitted region is any
 point within any of the rectangles.

* polygonalRegion [**PolygonalRegion**](#PolygonalRegion) <br>
contains a single instance of the PolygonalRegion
 structure.

* identifiedRegion [**SequenceOfIdentifiedRegion**](#SequenceOfIdentifiedRegion) <br>
is an array of IdentifiedRegion structures
 containing at least one entry. The permitted region is any point within
 any of the identified regions.

```asn1
GeographicRegion ::= CHOICE {
  circularRegion    CircularRegion,
  rectangularRegion SequenceOfRectangularRegion,
  polygonalRegion   PolygonalRegion,
  identifiedRegion  SequenceOfIdentifiedRegion,
  ...
}
```

### <a name="CircularRegion"></a>CircularRegion

 This structure specifies a circle with its center at center, its
 radius given in meters, and located tangential to the reference ellipsoid.
 The indicated region is all the points on the surface of the reference
 ellipsoid whose distance to the center point over the reference ellipsoid
 is less than or equal to the radius. A point which contains an elevation
 component is considered to be within the circular region if its horizontal
 projection onto the reference ellipsoid lies within the region.

Fields:
* center [**TwoDLocation**](#TwoDLocation) <br>
* radius [**Uint16**](Ieee1609Dot2BaseTypes.md#Uint16) <br>
```asn1
CircularRegion ::= SEQUENCE {
  center TwoDLocation,
  radius Uint16
}
```

### <a name="RectangularRegion"></a>RectangularRegion

 This structure specifies a rectangle on the surface of the WGS84 ellipsoid where the
 sides are given by lines of constant latitude or longitude.
 A point which contains an elevation component is considered to be within the rectangular region
 if its horizontal projection onto the reference ellipsoid lies within the region.
 A RectangularRegion is invalid if the northWest value is south of the southEast value, or if the
 latitude values in the two points are equal, or if the longitude values in the two points are
 equal; otherwise it is valid. A certificate that contains an invalid RectangularRegion is invalid.

Fields:
* northWest [**TwoDLocation**](#TwoDLocation) <br>
is the north-west corner of the rectangle.

* southEast [**TwoDLocation**](#TwoDLocation) <br>
is the south-east corner of the rectangle.

```asn1
RectangularRegion ::= SEQUENCE {
  northWest TwoDLocation,
  southEast TwoDLocation
}
```

### <a name="SequenceOfRectangularRegion"></a>SequenceOfRectangularRegion

 This type is used for clarity of definitions.



```asn1
SequenceOfRectangularRegion ::= SEQUENCE OF RectangularRegion
```

### <a name="PolygonalRegion"></a>PolygonalRegion

 This structure defines a region using a series of distinct
 geographic points, defined on the surface of the reference ellipsoid. The
 region is specified by connecting the points in the order they appear,
 with each pair of points connected by the geodesic on the reference
 ellipsoid. The polygon is completed by connecting the final point to the
 first point. The allowed region is the interior of the polygon and its
 boundary.

 A point which contains an elevation component is considered to be
 within the polygonal region if its horizontal projection onto the
 reference ellipsoid lies within the region.

 A valid PolygonalRegion contains at least three points. In a valid
 PolygonalRegion, the implied lines that make up the sides of the polygon
 do not intersect.

 @note This type does not support enclaves / exclaves. This might be
 addressed in a future version of this standard.

 @note Critical information fields: If present, this is a critical
 information field as defined in 5.2.6. An implementation that does not
 support the number of TwoDLocation in the PolygonalRegion when verifying a
 signed SPDU shall indicate that the signed SPDU is invalid. A compliant
 implementation shall support PolygonalRegions containing at least eight
 TwoDLocation entries.



```asn1
PolygonalRegion ::= SEQUENCE SIZE (3..MAX) OF TwoDLocation
```

### <a name="TwoDLocation"></a>TwoDLocation

 This structure is used to define validity regions for use in
 certificates. The latitude and longitude fields contain the latitude and
 longitude as defined above.

 @note This data structure is consistent with the location encoding
 used in SAE J2735, except that values 900 000 001 for latitude (used to
 indicate that the latitude was not available) and 1 800 000 001 for
 longitude (used to indicate that the longitude was not available) are not
 valid.

Fields:
* latitude [**Latitude**](#Latitude) <br>
* longitude [**Longitude**](#Longitude) <br>
```asn1
TwoDLocation ::= SEQUENCE {
  latitude  Latitude,
  longitude Longitude
}
```

### <a name="IdentifiedRegion"></a>IdentifiedRegion

 This structure indicates the region of validity of a certificate
 using region identifiers.
 A conformant implementation that supports this type shall support at least
 one of the possible CHOICE values. The Protocol Implementation Conformance
 Statement (PICS) provided in Annex A allows an implementation to state
 which CountryOnly values it recognizes.

 Critical information fields: If present, this is a critical
 information field as defined in 5.2.6. An implementation that does not
 recognize the indicated CHOICE when verifying a signed SPDU shall indicate
 that the signed SPDU is invalid in the sense of 4.2.2.3.2, that is, it is
 invalid in the sense that its validity cannot be established.

Fields:
* countryOnly [**UnCountryId**](#UnCountryId) <br>
indicates that only a country (or a geographic entity
 included in a country list) is given.

* countryAndRegions [**CountryAndRegions**](#CountryAndRegions) <br>
indicates that one or more top-level regions
 within a country (as defined by the region listing associated with that
 country) is given.

* countryAndSubregions [**CountryAndSubregions**](#CountryAndSubregions) <br>
indicates that one or more regions smaller
 than the top-level regions within a country (as defined by the region
 listing associated with that country) is given.

```asn1
IdentifiedRegion ::= CHOICE {
  countryOnly          UnCountryId,
  countryAndRegions    CountryAndRegions,
  countryAndSubregions CountryAndSubregions,
  ...
}
```

### <a name="SequenceOfIdentifiedRegion"></a>SequenceOfIdentifiedRegion

 This type is used for clarity of definitions.



```asn1
SequenceOfIdentifiedRegion ::= SEQUENCE OF IdentifiedRegion
```

### <a name="UnCountryId"></a>UnCountryId

 This type contains the integer representation of the country or
 area identifier as defined by the United Nations Statistics Division in
 October 2013 (see normative references in Clause 0).
 A conformant implementation that implements IdentifiedRegion shall
 recognize (in the sense of be able to determine whether a two dimensional
 location lies inside or outside the borders identified by) at least one
 value of UnCountryId. The Protocol Implementation Conformance Statement
 (PICS) provided in Annex A allows an implementation to state which
 UnCountryId values it recognizes.
 Since 2013 and before the publication of this version of this standard,
 three changes have been made to the country code list, to define the
 region "sub-Saharan Africa" and remove the "developed regions", and
 "developing regions". A conformant implementation may recognize these
 region identifiers in the sense defined in the previous paragraph.
 If a verifying implementation is required to check that relevant
 geographic information in a signed SPDU is consistent with a certificate
 containing one or more instances of this type, then the SDS is permitted
 to indicate that the signed SPDU is valid even if some instances of this
 type are unrecognized in the sense defined above, so long as the
 recognized instances of this type completely contain the relevant
 geographic information. Informally, if the recognized values in the
 certificate allow the SDS to determine that the SPDU is valid, then it
 can make that determination even if there are also unrecognized values in
 the certificate. This field is therefore not a "critical information
 field" as defined in 5.2.6, because unrecognized values are permitted so
 long as the validity of the SPDU can be established with the recognized
 values. However, as discussed in 5.2.6, the presence of an unrecognized
 value in a certificate can make it impossible to determine whether the
 certificate and the SPDU are valid.



```asn1
UnCountryId ::= Uint16
```

### <a name="CountryOnly"></a>CountryOnly

 This type is defined only for backwards compatibility.



```asn1
CountryOnly ::= UnCountryId
```

### <a name="CountryAndRegions"></a>CountryAndRegions

 A conformant implementation that supports CountryAndRegions shall
 support a regions field containing at least eight entries.
 A conformant implementation that implements this type shall recognize
 (in the sense of "be able to determine whether a two dimensional location
 lies inside or outside the borders identified by") at least one value of
 UnCountryId and at least one value for a region within the country
 indicated by that recognized UnCountryId value. In this version of this
 standard, the only means to satisfy this is for a conformant
 implementation to recognize the value of UnCountryId indicating USA and
 at least one of the FIPS state codes for US states. The Protocol
 Implementation Conformance Statement (PICS) provided in Annex A allows
 an implementation to state which UnCountryId values it recognizes and
 which region values are recognized within that country.
 If a verifying implementation is required to check that an relevant
 geographic information in a signed SPDU is consistent with a certificate
 containing one or more instances of this type, then the SDS is permitted
 to indicate that the signed SPDU is valid even if some values of country
 or within regions are unrecognized in the sense defined above, so long
 as the recognized instances of this type completely contain the relevant
 geographic information. Informally, if the recognized values in the
 certificate allow the SDS to determine that the SPDU is valid, then it
 can make that determination even if there are also unrecognized values
 in the certificate. This field is therefore not a "critical information
 field" as defined in 5.2.6, because unrecognized values are permitted so
 long as the validity of the SPDU can be established with the recognized
 values. However, as discussed in 5.2.6, the presence of an unrecognized
 value in a certificate can make it impossible to determine whether the
 certificate is valid and so whether the SPDU is valid.
 In this type:

Fields:
* countryOnly [**UnCountryId**](#UnCountryId) <br>
is a UnCountryId as defined above.

* regions [**SequenceOfUint8**](#SequenceOfUint8) <br>
identifies one or more regions within the country. If
 country indicates the United States of America, the values in this field
 identify the state or statistically equivalent entity using the integer
 version of the 2010 FIPS codes as provided by the U.S. Census Bureau
 (see normative references in Clause 0). For other values of country, the
 meaning of region is not defined in this version of this standard.

```asn1
CountryAndRegions ::= SEQUENCE {
  countryOnly UnCountryId,
  regions     SequenceOfUint8
}
```

### <a name="CountryAndSubregions"></a>CountryAndSubregions

 A conformant implementation that supports CountryAndSubregions
 shall support a regionAndSubregions field containing at least eight
 entries.
 A conformant implementation that implements this type shall recognize
 (in the sense of be able to determine whether a two dimensional location
 lies inside or outside the borders identified by) at least one value of
 country and at least one value for a region within the country indicated
 by that recognized country value. In this version of this standard, the
 only means to satisfy this is for a conformant implementation to recognize
 the value of UnCountryId indicating USA and at least one of the FIPS state
 codes for US states. The Protocol Implementation Conformance Statement
 (PICS) provided in Annex A allows an implementation to state which
 UnCountryId values it recognizes and which region values are recognized
 within that country.
 If a verifying implementation is required to check that an relevant
 geographic information in a signed SPDU is consistent with a certificate
 containing one or more instances of this type, then the SDS is permitted
 to indicate that the signed SPDU is valid even if some values of country
 or within regionAndSubregions are unrecognized in the sense defined above,
 so long as the recognized instances of this type completely contain the
 relevant geographic information. Informally, if the recognized values in
 the certificate allow the SDS to determine that the SPDU is valid, then
 it can make that determination even if there are also unrecognized values
 in the certificate. This field is therefore not a "critical information
 field" as defined in 5.2.6, because unrecognized values are permitted so
 long as the validity of the SPDU can be established with the recognized
 values. However, as discussed in 5.2.6, the presence of an unrecognized
 value in a certificate can make it impossible to determine whether the
 certificate is valid and so whether the SPDU is valid.
 In this structure:

Fields:
* countryOnly [**UnCountryId**](#UnCountryId) <br>
is a UnCountryId as defined above.

* regionAndSubregions [**SequenceOfRegionAndSubregions**](#SequenceOfRegionAndSubregions) <br>
identifies one or more subregions within
 country.

```asn1
CountryAndSubregions ::= SEQUENCE {
  countryOnly             UnCountryId,
  regionAndSubregions SequenceOfRegionAndSubregions
}
```

### <a name="RegionAndSubregions"></a>RegionAndSubregions

 The meanings of the fields in this structure are to be interpreted
 in the context of a country within which the region is located, referred
 to as the "enclosing country". If this structure is used in a
 CountryAndSubregions structure, the enclosing country is the one indicated
 by the country field in the CountryAndSubregions structure. If other uses
 are defined for this structure in future, it is expected that that
 definition will include a specification of how the enclosing country can
 be determined.
 If the enclosing country is the United States of America:
 - The region field identifies the state or statistically equivalent
 entity using the integer version of the 2010 FIPS codes as provided by the
 U.S. Census Bureau (see normative references in Clause 0).
 - The values in the subregions field identify the county or county
 equivalent entity using the integer version of the 2010 FIPS codes as
 provided by the U.S. Census Bureau.
 If the enclosing country is a different country from the USA, the meaning
 of regionAndSubregions is not defined in this version of this standard.
 A conformant implementation that implements this type shall recognize (in
 the sense of "be able to determine whether a two-dimensional location lies
 inside or outside the borders identified by"), for at least one enclosing
 country, at least one value for a region within that country and at least
 one subregion for the indicated region. In this version of this standard,
 the only means to satisfy this is for a conformant implementation to
 recognize, for the USA, at least one of the FIPS state codes for US
 states, and at least one of the county codes in at least one of the
 recognized states. The Protocol Implementation Conformance Statement
 (PICS) provided in Annex A allows an implementation to state which
 UnCountryId values it recognizes and which region values are recognized
 within that country.
 If a verifying implementation is required to check that an relevant
 geographic information in a signed SPDU is consistent with a certificate
 containing one or more instances of this type, then the SDS is permitted
 to indicate that the signed SPDU is valid even if some values within
 subregions are unrecognized in the sense defined above, so long as the
 recognized instances of this type completely contain the relevant
 geographic information. Informally, if the recognized values in the
 certificate allow the SDS to determine that the SPDU is valid, then it
 can make that determination even if there are also unrecognized values
 in the certificate. This field is therefore not not a "critical
 information field" as defined in 5.2.6, because unrecognized values are
 permitted so long as the validity of the SPDU can be established with the
 recognized values. However, as discussed in 5.2.6, the presence of an
 unrecognized value in a certificate can make it impossible to determine
 whether the certificate is valid and so whether the SPDU is valid.
 In this structure:

Fields:
* region [**Uint8**](Ieee1609Dot2BaseTypes.md#Uint8) <br>
identifies a region within a country.

* subregions [**SequenceOfUint16**](#SequenceOfUint16) <br>
identifies one or more subregions within region. A
 conformant implementation that supports RegionAndSubregions shall support
 a subregions field containing at least eight entries.

```asn1
RegionAndSubregions ::= SEQUENCE {
  region     Uint8,
  subregions SequenceOfUint16
}
```

### <a name="SequenceOfRegionAndSubregions"></a>SequenceOfRegionAndSubregions

 This type is used for clarity of definitions.



```asn1
SequenceOfRegionAndSubregions ::= SEQUENCE OF RegionAndSubregions
```

### <a name="ThreeDLocation"></a>ThreeDLocation

 This structure contains an estimate of 3D location. The details of
 the structure are given in the definitions of the individual fields below.

 @note The units used in this data structure are consistent with the
 location data structures used in 	SAE J2735 [B26], though the encoding is
 incompatible.

Fields:
* latitude [**Latitude**](#Latitude) <br>
* longitude [**Longitude**](#Longitude) <br>
* elevation [**Elevation**](#Elevation) <br>
```asn1
ThreeDLocation ::= SEQUENCE {
  latitude  Latitude,
  longitude Longitude,
  elevation Elevation
}
```

### <a name="Latitude"></a>Latitude

 This type contains an INTEGER encoding an estimate of the latitude
 with precision 1/10th microdegree relative to the World Geodetic System
 (WGS)-84 datum as defined in NIMA Technical Report TR8350.2.
 The integer in the latitude field is no more than 900 000 000 and no less
 than ?900 000 000, except that the value 900 000 001 is used to indicate
 the latitude was not available to the sender.



```asn1
Latitude ::= NinetyDegreeInt
```

### <a name="Longitude"></a>Longitude

 This type contains an INTEGER encoding an estimate of the longitude
 with precision 1/10th microdegree relative to the World Geodetic System
 (WGS)-84 datum as defined in NIMA Technical Report TR8350.2.
 The integer in the longitude field is no more than 1 800 000 000 and no
 less than ?1 799 999 999, except that the value 1 800 000 001 is used to
 indicate that the longitude was not available to the sender.



```asn1
Longitude ::= OneEightyDegreeInt
```

### <a name="Elevation"></a>Elevation

 This structure contains an estimate of the geodetic altitude above
 or below the WGS84 ellipsoid. The 16-bit value is interpreted as an
 integer number of decimeters representing the height above a minimum
 height of -409.5 m, with the maximum height being 6143.9 m.



```asn1
Elevation ::= Uint16
```

### <a name="NinetyDegreeInt"></a>NinetyDegreeInt

 The integer in the latitude field is no more than 900,000,000 and
 no less than -900,000,000, except that the value 900,000,001 is used to
 indicate the latitude was not available to the sender.

Values:
* **min** (-900000000)<br>
* **max** (900000000)<br>
* **unknown** (900000001)<br>
```asn1
NinetyDegreeInt ::= INTEGER {
  min     (-900000000),
  max     (900000000),
  unknown (900000001)
} (-900000000..900000001)
```

### <a name="KnownLatitude"></a>KnownLatitude

 The known latitudes are from -900,000,000 to +900,000,000 in 0.1
 microdegree intervals.



```asn1
KnownLatitude ::= NinetyDegreeInt (min..max)
```

### <a name="UnknownLatitude"></a>UnknownLatitude

 The value 900,000,001 indicates that the latitude was not
 available to the sender.



```asn1
UnknownLatitude ::= NinetyDegreeInt (unknown)
```

### <a name="OneEightyDegreeInt"></a>OneEightyDegreeInt

 The integer in the longitude field is no more than 1,800,000,000
 and no less than -1,799,999,999, except that the value 1,800,000,001 is
 used to indicate that the longitude was not available to the sender.

Values:
* **min** (-1799999999)<br>
* **max** (1800000000)<br>
* **unknown** (1800000001)<br>
```asn1
OneEightyDegreeInt ::= INTEGER {
  min     (-1799999999),
  max     (1800000000),
  unknown (1800000001)
} (-1799999999..1800000001)
```

### <a name="KnownLongitude"></a>KnownLongitude

 The known longitudes are from -1,799,999,999 to +1,800,000,000 in
 0.1 microdegree intervals.



```asn1
KnownLongitude ::= OneEightyDegreeInt (min..max)
```

### <a name="UnknownLongitude"></a>UnknownLongitude

 The value 1,800,000,001 indicates that the longitude was not
 available to the sender.



```asn1
UnknownLongitude ::= OneEightyDegreeInt (unknown)
```

### <a name="Signature"></a>Signature

 This structure represents a signature for a supported public key
 algorithm. It may be contained within SignedData or Certificate.

 @note Critical information fields: If present, this is a critical
 information field as defined in 5.2.5. An implementation that does not
 recognize the indicated CHOICE for this type when verifying a signed SPDU
 shall indicate that the signed SPDU is invalid in the sense of 4.2.2.3.2,
 that is, it is invalid in the sense that its validity cannot be
 established.

 @note Canonicalization: This data structure is subject to canonicalization
 for the relevant operations specified in 6.1.2. The canonicalization
 applies to instances of this data structure of form EcdsaP256Signature
 and EcdsaP384Signature.

Fields:
* ecdsaNistP256Signature [**EcdsaP256Signature**](#EcdsaP256Signature) <br>
* ecdsaBrainpoolP256r1Signature [**EcdsaP256Signature**](#EcdsaP256Signature) <br>
* ecdsaBrainpoolP384r1Signature [**EcdsaP384Signature**](#EcdsaP384Signature) <br>
* ecdsaNistP384Signature [**EcdsaP384Signature**](#EcdsaP384Signature) <br>
* sm2Signature [**EcsigP256Signature**](#EcsigP256Signature) <br>
```asn1
Signature ::= CHOICE {
  ecdsaNistP256Signature        EcdsaP256Signature,
  ecdsaBrainpoolP256r1Signature EcdsaP256Signature,
  ...,
  ecdsaBrainpoolP384r1Signature EcdsaP384Signature,
  ecdsaNistP384Signature        EcdsaP384Signature,
  sm2Signature                  EcsigP256Signature
}
```

### <a name="EcdsaP256Signature"></a>EcdsaP256Signature

 This structure represents an ECDSA signature. The signature is
 generated as specified in 5.3.1.

 If the signature process followed the specification of FIPS 186-4
 and output the integer r, r is represented as an EccP256CurvePoint
 indicating the selection x-only.

 If the signature process followed the specification of SEC 1 and
 output the elliptic curve point R to allow for fast verification, R is
 represented as an EccP256CurvePoint indicating the choice compressed-y-0,
 compressed-y-1, or uncompressed at the sender's discretion.

 @note Canonicalization: This data structure is subject to canonicalization
 for the relevant operations specified in 6.1.2. When this data structure
 is canonicalized, the EccP256CurvePoint in rSig is represented in the
 form x-only.

 @note When the signature is of form x-only, the x-value in rSig is
 an integer mod n, the order of the group; when the signature is of form
 compressed-y-\*, the x-value in rSig is an integer mod p, the underlying
 prime defining the finite field. In principle this means that to convert a
 signature from form compressed-y-\* to form x-only, the converter checks
 the x-value to see if it lies between n and p and reduces it mod n if so.
 In practice this check is unnecessary: Haase's Theorem states that
 difference between n and p is always less than 2*square-root(p), and so the
 chance that an integer lies between n and p, for a 256-bit curve, is
 bounded above by approximately square-root(p)/p or 2^(-128). For the
 256-bit curves in this standard, the exact values of n and p in hexadecimal
 are:

 NISTp256:
   - p = FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
   - n = FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551

 Brainpoolp256:
   - p = A9FB57DBA1EEA9BC3E660A909D838D726E3BF623D52620282013481D1F6E5377
   - n = A9FB57DBA1EEA9BC3E660A909D838D718C397AA3B561A6F7901E0E82974856A7

Fields:
* rSig [**EccP256CurvePoint**](Ieee1609Dot2BaseTypes.md#EccP256CurvePoint) <br>
* sSig **OCTET STRING**  (SIZE (32))<br>
```asn1
EcdsaP256Signature ::= SEQUENCE {
  rSig EccP256CurvePoint,
  sSig OCTET STRING (SIZE (32))
}
```

### <a name="EcdsaP384Signature"></a>EcdsaP384Signature

 This structure represents an ECDSA signature. The signature is
 generated as specified in 5.3.1.

 If the signature process followed the specification of FIPS 186-4
 and output the integer r, r is represented as an EccP384CurvePoint
 indicating the selection x-only.

 If the signature process followed the specification of SEC 1 and
 output the elliptic curve point R to allow for fast verification, R is
 represented as an EccP384CurvePoint indicating the choice compressed-y-0,
 compressed-y-1, or uncompressed at the sender's discretion.

 @note Canonicalization: This data structure is subject to canonicalization
 for the relevant operations specified in 6.1.2. When this data structure
 is canonicalized, the EccP384CurvePoint in rSig is represented in the
 form x-only.

 @note When the signature is of form x-only, the x-value in rSig is
 an integer mod n, the order of the group; when the signature is of form
 compressed-y-\*, the x-value in rSig is an integer mod p, the underlying
 prime defining the finite field. In principle this means that to convert a
 signature from form compressed-y-* to form x-only, the converter checks the
 x-value to see if it lies between n and p and reduces it mod n if so. In
 practice this check is unnecessary: Haase's Theorem states that difference
 between n and p is always less than 2*square-root(p), and so the chance
 that an integer lies between n and p, for a 384-bit curve, is bounded
 above by approximately square-root(p)/p or 2^(-192). For the 384-bit curve
 in this standard, the exact values of n and p in hexadecimal are:
   - p = 8CB91E82A3386D280F5D6F7E50E641DF152F7109ED5456B412B1DA197FB71123
 ACD3A729901D1A71874700133107EC53
   - n = 8CB91E82A3386D280F5D6F7E50E641DF152F7109ED5456B31F166E6CAC0425A7
 CF3AB6AF6B7FC3103B883202E9046565

Fields:
* rSig [**EccP384CurvePoint**](#EccP384CurvePoint) <br>
* sSig **OCTET STRING**  (SIZE (48))<br>
```asn1
EcdsaP384Signature ::= SEQUENCE {
  rSig EccP384CurvePoint,
  sSig OCTET STRING (SIZE (48))
}
```

### <a name="EcsigP256Signature"></a>EcsigP256Signature

 This structure represents a elliptic curve signature where the
 component r is constrained to be an integer. This structure supports SM2
 signatures as specified in 5.3.1.3.

Fields:
* rSig **OCTET STRING**  (SIZE (32))<br>
* sSig **OCTET STRING**  (SIZE (32))<br>
```asn1
EcsigP256Signature ::= SEQUENCE  {
  rSig OCTET STRING (SIZE (32)),
  sSig OCTET STRING (SIZE (32))
}
```

### <a name="EccP256CurvePoint"></a>EccP256CurvePoint

 This structure specifies a point on an elliptic curve in Weierstrass
 form defined over a 256-bit prime number. The curves supported in this
 standard are NIST p256 as defined in FIPS 186-4, Brainpool p256r1 as
 defined in RFC 5639, and the SM2 curve as defined in GB/T 32918.5-2017.
 The fields in this structure are OCTET STRINGS produced with the elliptic
 curve point encoding and decoding methods defined in subclause 5.5.6 of
 IEEE Std 1363-2000. The x-coordinate is encoded as an unsigned integer of
 length 32 octets in network byte order for all values of the CHOICE; the
 encoding of the y-coordinate y depends on whether the point is x-only,
 compressed, or uncompressed. If the point is x-only, y is omitted. If the
 point is compressed, the value of type depends on the least significant
 bit of y: if the least significant bit of y is 0, type takes the value
 compressed-y-0, and if the least significant bit of y is 1, type takes the
 value compressed-y-1. If the point is uncompressed, y is encoded explicitly
 as an unsigned integer of length 32 octets in network byte order.

 @note Canonicalization: This data structure is subject to canonicalization
 for the relevant operations specified in 6.1.2 if it appears in a
 HeaderInfo or in a ToBeSignedCertificate. See the definitions of HeaderInfo
 and ToBeSignedCertificate for a specification of the canonicalization
 operations.

Fields:
* x-only **OCTET STRING**  (SIZE (32))<br>
* fill **NULL** <br>
* compressed-y-0 **OCTET STRING**  (SIZE (32))<br>
* compressed-y-1 **OCTET STRING**  (SIZE (32))<br>
* uncompressedP256 **SEQUENCE**  {
    x OCTET STRING (SIZE (32)),
    y OCTET STRING (SIZE (32))
  }<br>
```asn1
EccP256CurvePoint::= CHOICE {
  x-only           OCTET STRING (SIZE (32)),
  fill             NULL,
  compressed-y-0   OCTET STRING (SIZE (32)),
  compressed-y-1   OCTET STRING (SIZE (32)),
  uncompressedP256 SEQUENCE {
    x OCTET STRING (SIZE (32)),
    y OCTET STRING (SIZE (32))
  }
}
```

### <a name="EccP384CurvePoint"></a>EccP384CurvePoint

 This structure specifies a point on an elliptic curve in
 Weierstrass form defined over a 384-bit prime number. The only supported
 such curve in this standard is Brainpool p384r1 as defined in RFC 5639.
 The fields in this structure are octet strings produced with the elliptic
 curve point encoding and decoding methods defined in subclause 5.5.6 of
 IEEE Std 1363-2000. The x-coordinate is encoded as an unsigned integer of
 length 48 octets in network byte order for all values of the CHOICE; the
 encoding of the y-coordinate y depends on whether the point is x-only,
 compressed, or uncompressed. If the point is x-only, y is omitted. If the
 point is compressed, the value of type depends on the least significant
 bit of y: if the least significant bit of y is 0, type takes the value
 compressed-y-0, and if the least significant bit of y is 1, type takes the
 value compressed-y-1. If the point is uncompressed, y is encoded
 explicitly as an unsigned integer of length 48 octets in network byte order.

 @note Canonicalization: This data structure is subject to canonicalization
 for the relevant operations specified in 6.1.2 if it appears in a
 HeaderInfo or in a ToBeSignedCertificate. See the definitions of HeaderInfo
 and ToBeSignedCertificate for a specification of the canonicalization
 operations.

Fields:
* x-only **OCTET STRING**  (SIZE (48))<br>
* fill **NULL** <br>
* compressed-y-0 **OCTET STRING**  (SIZE (48))<br>
* compressed-y-1 **OCTET STRING**  (SIZE (48))<br>
* uncompressedP384 **SEQUENCE**  {
    x OCTET STRING (SIZE (48)),
    y OCTET STRING (SIZE (48))
  }<br>
```asn1
EccP384CurvePoint::= CHOICE {
  x-only           OCTET STRING (SIZE (48)),
  fill             NULL,	
  compressed-y-0   OCTET STRING (SIZE (48)),
  compressed-y-1   OCTET STRING (SIZE (48)),
  uncompressedP384 SEQUENCE {
    x OCTET STRING (SIZE (48)),
    y OCTET STRING (SIZE (48))
  }
}
```

### <a name="SymmAlgorithm"></a>SymmAlgorithm

 This enumerated value indicates supported symmetric algorithms. The
 algorithm identifier identifies both the algorithm itself and a specific
 mode of operation. The symmetric algorithms supported in this version of
 this standard are AES-128 and SM4. The only mode of operation supported is
 Counter Mode Encryption With Cipher Block Chaining Message Authentication
 Code (CCM). Full details are given in 5.3.8.



```asn1
SymmAlgorithm ::= ENUMERATED { 
  aes128Ccm,
  ...,
  sm4Ccm
}
```

### <a name="HashAlgorithm"></a>HashAlgorithm

 This structure identifies a hash algorithm. The value sha256,
 indicates SHA-256. The value sha384 indicates SHA-384. The value sm3
 indicates SM3. See 5.3.3 for more details.

 @note Critical information fields: This is a critical information field as
 defined in 5.2.6. An implementation that does not recognize the enumerated
 value of this type in a signed SPDU when verifying a signed SPDU shall
 indicate that the signed SPDU is invalid in the sense of 4.2.2.3.2, that
 is, it is invalid in the sense that its validity cannot be established.



```asn1
HashAlgorithm ::= ENUMERATED { 
  sha256,
  ...,
  sha384,
  sm3
}
```

### <a name="EciesP256EncryptedKey"></a>EciesP256EncryptedKey

 This data structure is used to transfer a 16-byte symmetric key
 encrypted using ECIES as specified in IEEE Std 1363a-2004. The symmetric
 key is input to the key encryption process with no headers, encapsulation,
 or length indication. Encryption and decryption are carried out as
 specified in 5.3.5.1.

Fields:
* v [**EccP256CurvePoint**](Ieee1609Dot2BaseTypes.md#EccP256CurvePoint) <br>
is the sender's ephemeral public key, which is the output V from
 encryption as specified in 5.3.5.1.

* c **OCTET STRING**  (SIZE (16))<br>
is the encrypted symmetric key, which is the output C from
 encryption as specified in 5.3.5.1. The algorithm for the symmetric key
 is identified by the CHOICE indicated in the following SymmetricCiphertext.
 For ECIES this shall be AES-128.

* t **OCTET STRING**  (SIZE (16))<br>
is the authentication tag, which is the output tag from
 encryption as specified in 5.3.5.1.

```asn1
EciesP256EncryptedKey ::= SEQUENCE {
  v EccP256CurvePoint,
  c OCTET STRING (SIZE (16)),
  t OCTET STRING (SIZE (16))     
}
```

### <a name="EcencP256EncryptedKey"></a>EcencP256EncryptedKey

 This data structure is used to transfer a 16-byte symmetric key
 encrypted using SM2 encryption as specified in 5.3.3. The symmetric key is
 input to the key encryption process with no headers, encapsulation, or
 length indication. Encryption and decryption are carried out as specified
 in 5.3.5.2.

Fields:
* v [**EccP256CurvePoint**](Ieee1609Dot2BaseTypes.md#EccP256CurvePoint) <br>
is the sender's ephemeral public key, which is the output V from
 encryption as specified in 5.3.5.2.

* c **OCTET STRING**  (SIZE (16))<br>
is the encrypted symmetric key, which is the output C from
 encryption as specified in 5.3.5.2. The algorithm for the symmetric key
 is identified by the CHOICE indicated in the following SymmetricCiphertext.
 For SM2 this algorithm shall be SM4.

* t **OCTET STRING**  (SIZE (32))<br>
is the authentication tag, which is the output tag from
 encryption as specified in 5.3.5.2.

```asn1
EcencP256EncryptedKey ::= SEQUENCE  {
  v EccP256CurvePoint,
  c OCTET STRING (SIZE (16)),
  t OCTET STRING (SIZE (32))     
}
```

### <a name="EncryptionKey"></a>EncryptionKey

 This structure contains an encryption key, which may be a public or
 a symmetric key.

 @note Canonicalization: This data structure is subject to canonicalization
 for the relevant operations specified in 6.1.2 if it appears in a
 HeaderInfo or in a ToBeSignedCertificate. The canonicalization applies to
 the PublicEncryptionKey. See the definitions of HeaderInfo and
 ToBeSignedCertificate for a specification of the canonicalization
 operations.

Fields:
* public [**PublicEncryptionKey**](Ieee1609Dot2BaseTypes.md#PublicEncryptionKey) <br>
* symmetric [**SymmetricEncryptionKey**](Ieee1609Dot2BaseTypes.md#SymmetricEncryptionKey) <br>
```asn1
EncryptionKey ::= CHOICE {
  public    PublicEncryptionKey,
  symmetric SymmetricEncryptionKey 
}
```

### <a name="PublicEncryptionKey"></a>PublicEncryptionKey

 This structure specifies a public encryption key and the associated
 symmetric algorithm which is used for bulk data encryption when encrypting
 for that public key.

 @note Canonicalization: This data structure is subject to canonicalization
 for the relevant operations specified in 6.1.2 if it appears in a
 HeaderInfo or in a ToBeSignedCertificate. The canonicalization applies to
 the BasePublicEncryptionKey. See the definitions of HeaderInfo and
 ToBeSignedCertificate for a specification of the canonicalization
 operations.

Fields:
* supportedSymmAlg [**SymmAlgorithm**](#SymmAlgorithm) <br>
* publicKey [**BasePublicEncryptionKey**](#BasePublicEncryptionKey) <br>
```asn1
PublicEncryptionKey ::= SEQUENCE { 
  supportedSymmAlg SymmAlgorithm,
  publicKey        BasePublicEncryptionKey
}
```

### <a name="BasePublicEncryptionKey"></a>BasePublicEncryptionKey

 This structure specifies the bytes of a public encryption key for
 a particular algorithm. Supported public key encryption algorithms are
 defined in 5.3.5.

 @note Canonicalization: This data structure is subject to canonicalization
 for the relevant operations specified in 6.1.2 if it appears in a
 HeaderInfo or in a ToBeSignedCertificate. See the definitions of HeaderInfo
 and ToBeSignedCertificate for a specification of the canonicalization
 operations.

Fields:
* eciesNistP256 [**EccP256CurvePoint**](Ieee1609Dot2BaseTypes.md#EccP256CurvePoint) <br>
* eciesBrainpoolP256r1 [**EccP256CurvePoint**](Ieee1609Dot2BaseTypes.md#EccP256CurvePoint) <br>
* ecencSm2 [**EccP256CurvePoint**](Ieee1609Dot2BaseTypes.md#EccP256CurvePoint) <br>
```asn1
BasePublicEncryptionKey ::= CHOICE { 
  eciesNistP256        EccP256CurvePoint,
  eciesBrainpoolP256r1 EccP256CurvePoint,
  ...,
  ecencSm2             EccP256CurvePoint
}
```

### <a name="PublicVerificationKey"></a>PublicVerificationKey

 This structure represents a public key and states with what
 algorithm the public key is to be used. Cryptographic mechanisms are
 defined in 5.3.
 An EccP256CurvePoint or EccP384CurvePoint within a PublicVerificationKey
 structure is invalid if it indicates the choice x-only.

 @note Critical information fields: If present, this is a critical
 information field as defined in 5.2.6. An implementation that does not
 recognize the indicated CHOICE when verifying a signed SPDU shall indicate
 that the signed SPDU is invalid indicate that the signed SPDU is invalid
 in the sense of 4.2.2.3.2, that is, it is invalid in the sense that its
 validity cannot be established.

 @note Canonicalization: This data structure is subject to canonicalization
 for the relevant operations specified in 6.1.2. The canonicalization
 applies to the EccP256CurvePoint and the Ecc384CurvePoint. Both forms of
 point are encoded in compressed form, i.e., such that the choice indicated
 within the Ecc*CurvePoint is compressed-y-0 or compressed-y-1.

Fields:
* ecdsaNistP256 [**EccP256CurvePoint**](Ieee1609Dot2BaseTypes.md#EccP256CurvePoint) <br>
* ecdsaBrainpoolP256r1 [**EccP256CurvePoint**](Ieee1609Dot2BaseTypes.md#EccP256CurvePoint) <br>
* ecdsaBrainpoolP384r1 [**EccP384CurvePoint**](#EccP384CurvePoint) <br>
* ecdsaNistP384 [**EccP384CurvePoint**](#EccP384CurvePoint) <br>
* ecsigSm2 [**EccP256CurvePoint**](Ieee1609Dot2BaseTypes.md#EccP256CurvePoint) <br>
```asn1
PublicVerificationKey ::= CHOICE { 
  ecdsaNistP256        EccP256CurvePoint,
  ecdsaBrainpoolP256r1 EccP256CurvePoint,
  ... ,
  ecdsaBrainpoolP384r1 EccP384CurvePoint,
  ecdsaNistP384        EccP384CurvePoint,
  ecsigSm2             EccP256CurvePoint
}
```

### <a name="SymmetricEncryptionKey"></a>SymmetricEncryptionKey

 This structure provides the key bytes for use with an identified
 symmetric algorithm. The supported symmetric algorithms are AES-128 and
 SM4 in CCM mode as specified in 5.3.8.

Fields:
* aes128Ccm **OCTET STRING** (SIZE(16))<br>
* sm4Ccm **OCTET STRING** (SIZE(16))<br>
```asn1
SymmetricEncryptionKey ::= CHOICE {
  aes128Ccm OCTET STRING(SIZE(16)),
  ...,
  sm4Ccm    OCTET STRING(SIZE(16))
}
```

### <a name="PsidSsp"></a>PsidSsp

 This structure represents the permissions that the certificate
 holder has with respect to activities for a single application area,
 identified by a Psid.

 @note The determination as to whether the activities are consistent with
 the permissions indicated by the PSID and ServiceSpecificPermissions is
 made by the SDEE and not by the SDS; the SDS provides the PSID and SSP
 information to the SDEE to enable the SDEE to make that determination.
 See 5.2.4.3.3 for more information.

 @note The SDEE specification is expected to specify what application
 activities are permitted by particular ServiceSpecificPermissions values.
 The SDEE specification is also expected EITHER to specify application
 activities that are permitted if the ServiceSpecificPermissions is
 omitted, OR to state that the ServiceSpecificPermissions need to always be
 present.

 @note Consistency with signed SPDU: As noted in 5.1.1,
 consistency between the SSP and the signed SPDU is defined by rules
 specific to the given PSID and is out of scope for this standard.

 @note Consistency with issuing certificate: If a certificate has an
 appPermissions entry A for which the ssp field is omitted, A is consistent
 with the issuing certificate if the issuing certificate contains a
 PsidSspRange P for which the following holds:
   - The psid field in P is equal to the psid field in A and one of the
 following is true:
     - The sspRange field in P indicates all.
     - The sspRange field in P indicates opaque and one of the entries in
 opaque is an OCTET STRING of length 0.

 For consistency rules for other forms of the ssp field, see the
 following subclauses.

Fields:
* psid [**Psid**](Ieee1609Dot2BaseTypes.md#Psid) <br>
* ssp [**ServiceSpecificPermissions**](Ieee1609Dot2BaseTypes.md#ServiceSpecificPermissions)  OPTIONAL<br>
```asn1
PsidSsp ::= SEQUENCE {
  psid Psid,
  ssp  ServiceSpecificPermissions OPTIONAL
}
```

### <a name="SequenceOfPsidSsp"></a>SequenceOfPsidSsp

 This type is used for clarity of definitions.



```asn1
SequenceOfPsidSsp ::= SEQUENCE OF PsidSsp
```

### <a name="Psid"></a>Psid

 This type represents the PSID defined in IEEE Std 1609.12.



```asn1
Psid ::= INTEGER (0..MAX)
```

### <a name="SequenceOfPsid"></a>SequenceOfPsid

 This type is used for clarity of definitions.



```asn1
SequenceOfPsid ::= SEQUENCE OF Psid
```

### <a name="ServiceSpecificPermissions"></a>ServiceSpecificPermissions

 This structure represents the Service Specific Permissions (SSP)
 relevant to a given entry in a PsidSsp. The meaning of the SSP is specific
 to the associated Psid. SSPs may be PSID-specific octet strings or
 bitmap-based. See Annex C for further discussion of how application
 specifiers may choose which SSP form to use.

 @note Consistency with issuing certificate: If a certificate has an
 appPermissions entry A for which the ssp field is opaque, A is consistent
 with the issuing certificate if the issuing certificate contains one of
 the following:
   - (OPTION 1) A SubjectPermissions field indicating the choice all and
 no PsidSspRange field containing the psid field in A;
   - (OPTION 2) A PsidSspRange P for which the following holds:
     - The psid field in P is equal to the psid field in A and one of the
 following is true:
       - The sspRange field in P indicates all.
       - The sspRange field in P indicates opaque and one of the entries in
 the opaque field in P is an OCTET STRING identical to the opaque field in
 A.

 For consistency rules for other types of ServiceSpecificPermissions,
 see the following subclauses.

Fields:
* opaque **OCTET STRING**  (SIZE(0..MAX))<br>
* bitmapSsp [**BitmapSsp**](#BitmapSsp) <br>
```asn1
ServiceSpecificPermissions ::= CHOICE {
  opaque    OCTET STRING (SIZE(0..MAX)),
  ...,
  bitmapSsp BitmapSsp
}
```

### <a name="BitmapSsp"></a>BitmapSsp

 This structure represents a bitmap representation of a SSP. The
 mapping of the bits of the bitmap to constraints on the signed SPDU is
 PSID-specific.

 @note Consistency with issuing certificate: If a certificate has an
 appPermissions entry A for which the ssp field is bitmapSsp, A is
 consistent with the issuing certificate if the  certificate contains one
 of the following:
   - (OPTION 1) A SubjectPermissions field indicating the choice all and
 no PsidSspRange field containing the psid field in A;
   - (OPTION 2) A PsidSspRange P for which the following holds:
     - The psid field in P is equal to the psid field in A and one of the
 following is true:
       - EITHER The sspRange field in P indicates all
       - OR The sspRange field in P indicates bitmapSspRange and for every
 bit set to 1 in the sspBitmask in P, the bit in the identical position in
 the sspValue in A is set equal to the bit in that position in the
 sspValue in P.

 @note A BitmapSsp B is consistent with a BitmapSspRange R if for every
 bit set to 1 in the sspBitmask in R, the bit in the identical position in
 B is set equal to the bit in that position in the sspValue in R. For each
 bit set to 0 in the sspBitmask in R, the corresponding bit in the
 identical position in B may be freely set to 0 or 1, i.e., if a bit is
 set to 0 in the sspBitmask in R, the value of corresponding bit in the
 identical position in B has no bearing on whether B and R are consistent.



```asn1
BitmapSsp ::= OCTET STRING (SIZE(0..31))
```

### <a name="PsidSspRange"></a>PsidSspRange

 This structure represents the certificate issuing or requesting
 permissions of the certificate holder with respect to one particular set
 of application permissions.

Fields:
* psid [**Psid**](Ieee1609Dot2BaseTypes.md#Psid) <br>
identifies the application area.

* sspRange [**SspRange**](#SspRange)  OPTIONAL<br>
identifies the SSPs associated with that PSID for which
 the holder may issue or request certificates. If sspRange is omitted, the
 holder may issue or request certificates for any SSP for that PSID.

```asn1
PsidSspRange ::= SEQUENCE {
  psid     Psid,
  sspRange SspRange OPTIONAL
}
```

### <a name="SequenceOfPsidSspRange"></a>SequenceOfPsidSspRange

 This type is used for clarity of definitions.



```asn1
SequenceOfPsidSspRange ::= SEQUENCE OF PsidSspRange
```

### <a name="SspRange"></a>SspRange

 This structure identifies the SSPs associated with a PSID for
 which the holder may issue or request certificates.

 @note Consistency with issuing certificate: If a certificate has a
 PsidSspRange A for which the ssp field is opaque, A is consistent with
 the issuing certificate if the issuing certificate contains one of the
 following:
   - (OPTION 1) A SubjectPermissions field indicating the choice all and
 no PsidSspRange field containing the psid field in A;
   - (OPTION 2) A PsidSspRange P for which the following holds:
     - The psid field in P is equal to the psid field in A and one of the
 following is true:
       - The sspRange field in P indicates all.
       - The sspRange field in P indicates opaque, and the sspRange field in
 A indicates opaque, and every OCTET STRING within the opaque in A is a
 duplicate of an OCTET STRING within the opaque in P.

 If a certificate has a PsidSspRange A for which the ssp field is all,
 A is consistent with the issuing certificate if the issuing certificate
 contains a PsidSspRange P for which the following holds:
   - (OPTION 1) A SubjectPermissions field indicating the choice all and
 no PsidSspRange field containing the psid field in A;
   - (OPTION 2) A PsidSspRange P for which the psid field in P is equal to
 the psid field in A and the sspRange field in P indicates all.

 For consistency rules for other types of SspRange, see the following
 subclauses.

 @note The choice "all" may also be indicated by omitting the
 SspRange in the enclosing PsidSspRange structure. Omitting the SspRange is
 preferred to explicitly indicating "all".

Fields:
* opaque [**SequenceOfOctetString**](#SequenceOfOctetString) <br>
* all **NULL** <br>
* bitmapSspRange [**BitmapSspRange**](#BitmapSspRange) <br>
```asn1
SspRange ::= CHOICE {
  opaque         SequenceOfOctetString,
  all            NULL,
  ...,
  bitmapSspRange BitmapSspRange
}
```

### <a name="BitmapSspRange"></a>BitmapSspRange

 This structure represents a bitmap representation of a SSP. The
 sspValue indicates permissions. The sspBitmask contains an octet string
 used to permit or constrain sspValue fields in issued certificates. The
 sspValue and sspBitmask fields shall be of the same length.

 @note Consistency with issuing certificate: If a certificate has an
 PsidSspRange value P for which the sspRange field is bitmapSspRange,
 P is consistent with the issuing certificate if the issuing certificate
 contains one of the following:
   - (OPTION 1) A SubjectPermissions field indicating the choice all and
 no PsidSspRange field containing the psid field in P;
   - (OPTION 2) A PsidSspRange R for which the following holds:
     - The psid field in R is equal to the psid field in P and one of the
 following is true:
       - EITHER The sspRange field in R indicates all
       - OR The sspRange field in R indicates bitmapSspRange and for every
 bit set to 1 in the sspBitmask in R:
         - The bit in the identical position in the sspBitmask in P is set
 equal to 1, AND
         - The bit in the identical position in the sspValue in P is set equal
 to the bit in that position in the sspValue in R.

 Reference ETSI TS 103 097 for more information on bitmask SSPs.

Fields:
* sspValue **OCTET STRING**  (SIZE(1..32))<br>
* sspBitmask **OCTET STRING**  (SIZE(1..32))<br>
```asn1
BitmapSspRange ::= SEQUENCE {
  sspValue   OCTET STRING (SIZE(1..32)),
  sspBitmask OCTET STRING (SIZE(1..32))
}
```

### <a name="SubjectAssurance"></a>SubjectAssurance

 This type is used for clarity of definitions.

 This field contains the certificate holder's assurance level, which
 indicates the security of both the platform and storage of secret keys as
 well as the confidence in this assessment.

 This field is encoded as defined in Table 1, where "A" denotes bit
 fields specifying an assurance level, "R" reserved bit fields, and "C" bit
 fields specifying the confidence.

 Table 1: Bitwise encoding of subject assurance

 | Bit number     |  7  |  6  |  5  |  4  |  3  |  2  |  1  |  0  |
 | -------------- | --- | --- | --- | --- | --- | --- | --- | --- |
 | Interpretation |  A  |  A  |  A  |  R  |  R  |  R  |  C  |  C  |

 In Table 1, bit number 0 denotes the least significant bit. Bit 7
 to bit 5 denote the device's assurance levels, bit 4 to bit 2 are reserved
 for future use, and bit 1 and bit 0 denote the confidence.

 The specification of these assurance levels as well as the
 encoding of the confidence levels is outside the scope of the present
 standard. It can be assumed that a higher assurance value indicates that
 the holder is more trusted than the holder of a certificate with lower
 assurance value and the same confidence value.

 @note This field was originally specified in ETSI TS 103 097 and
 future uses of this field are anticipated to be consistent with future
 versions of that standard.



```asn1
SubjectAssurance ::= OCTET STRING (SIZE(1))
```

### <a name="CrlSeries"></a>CrlSeries

 This integer identifies a series of CRLs issued under the authority
 of a particular CRACA.



```asn1
CrlSeries ::= Uint16
```

### <a name="IValue"></a>IValue

 This atomic type is used in the definition of other data structures.



```asn1
IValue ::= Uint16
```

### <a name="Hostname"></a>Hostname

 This is a UTF-8 string as defined in IETF RFC 3629. The contents
 are determined by policy.



```asn1
Hostname ::= UTF8String (SIZE(0..255))
```

### <a name="LinkageValue"></a>LinkageValue

 This is the individual linkage value. See 5.1.3 and 7.3 for details
 of use.



```asn1
LinkageValue ::= OCTET STRING (SIZE(9))
```

### <a name="GroupLinkageValue"></a>GroupLinkageValue

 This is the group linkage value. See 5.1.3 and 7.3 for details of
 use.

Fields:
* jValue **OCTET STRING**  (SIZE(4))<br>
* value **OCTET STRING**  (SIZE(9))<br>
```asn1
GroupLinkageValue ::= SEQUENCE {
  jValue OCTET STRING (SIZE(4)),
  value  OCTET STRING (SIZE(9))
}
```

### <a name="LaId"></a>LaId

 This structure contains a LA Identifier for use in the algorithms
 specified in 5.1.3.4.



```asn1
LaId ::= OCTET STRING (SIZE(2))
```

### <a name="SequenceOfLinkageSeed"></a>SequenceOfLinkageSeed

 This type is used for clarity of definitions.



```asn1
SequenceOfLinkageSeed ::= SEQUENCE OF LinkageSeed
```

### <a name="LinkageSeed"></a>LinkageSeed

 This structure contains a linkage seed value for use in the
 algorithms specified in 5.1.3.4.



```asn1
LinkageSeed ::= OCTET STRING (SIZE(16))
```

### <a name="CERT-EXT-TYPE"></a>CERT-EXT-TYPE

 This structure is the Information Object Class used to contain
 information about a set of certificate extensions that are associated with
 each other: an AppExtension, a CertIssueExtension, and a
 CertRequestExtension.



```asn1
CERT-EXT-TYPE ::= CLASS {
  &id        ExtId,
  &App,
  &Issue,
  &Req
} WITH SYNTAX {ID &id APP &App ISSUE &Issue REQUEST &Req}
```

### <a name="Extension"></a>Extension

 This parameterized type represents a (id, content) pair drawn from
 the set ExtensionTypes, which is constrained to contain objects defined by
 the class EXT-TYPE.

Fields:
* id [**EXT-TYPE**](Ieee1609Dot2BaseTypes.md#EXT-TYPE) .&extId({ExtensionTypes})<br>
* content [**EXT-TYPE**](Ieee1609Dot2BaseTypes.md#EXT-TYPE) .&ExtContent({ExtensionTypes}{@.id})<br>
```asn1
Extension {EXT-TYPE : ExtensionTypes} ::= SEQUENCE {
  id      EXT-TYPE.&extId({ExtensionTypes}),
  content EXT-TYPE.&ExtContent({ExtensionTypes}{@.id})
}
```

### <a name="EXT-TYPE"></a>EXT-TYPE

 This class defines objects in a form suitable for import into the
 definition of HeaderInfo.



```asn1
EXT-TYPE ::= CLASS {
  &extId      ExtId,
  &ExtContent
} WITH SYNTAX {&ExtContent IDENTIFIED BY &extId}
```

### <a name="ExtId"></a>ExtId

 This type is used as an identifier for instances of ExtContent
 within an EXT-TYPE.



```asn1
ExtId ::= INTEGER(0..255)
```



